#include <iostream>
#include <vector>
#include <array>

using namespace std;

struct segtree
{
    vector<char> lazy;
    vector<int> counter;
    
    int n;
    
    void push(int v, int l, int r)
    {
        if (lazy[v] != 'c')
        {
            lazy[v << 1] = lazy[v];
            lazy[v << 1 | 1] = lazy[v];
            int m = (l + r) >> 1;
            if (lazy[v] == 'a')
            {
                counter[v << 1] = m - l + 1;
                counter[v << 1 | 1] = r - m;
            }
            else counter[v << 1] = counter[v << 1 | 1] = 0;
        }
        lazy[v] = 'c';
    }
    
    void build(int v, int l, int r, string &s)
    {
        if (l == r)
        {
            if (s[l] == 'a') counter[v] = 1;
            return;
        }
        int m = (l + r) >> 1;
        build(v << 1, l, m, s);
        build(v << 1 | 1, m + 1, r, s);
        counter[v] = counter[v << 1] + counter[v << 1 | 1];
    }
    
    segtree(string &s) : n((int)s.size())
    {
        lazy.resize(4 * n, 'c');
        counter.resize(4 * n);
        build(1, 0, n - 1, s);
    }
    
    int get(char val, int x, int v, int l, int r)
    {
        int cnt = (val == 'a' ? counter[v] : r - l + 1 - counter[v]);
        if (l > r || cnt < x) return -1;
        if (l == r) return l;
        push(v, l, r);
        int m = (l + r) >> 1;
        cnt = (val == 'a' ? counter[v << 1] : m - l + 1 - counter[v << 1]);
        if (cnt >= x) return get(val, x, v << 1, l, m);
        return get(val, x - cnt, v << 1 | 1, m + 1, r);
    }
    
    int get(int val, int x)
    {
        return get(val, x, 1, 0, n - 1);
    }
    
    void update(char val ,int a, int b, int v, int l, int r)
    {
        if (a > r || b < l) return;
        if (a == l && b == r)
        {
            lazy[v] = val;
            if (lazy[v] == 'a') counter[v] = r - l + 1;
            else counter[v] = 0;
            return;
        }
        push(v, l, r);
        int m = (l + r) >> 1;
        update(val, a, min(b, m), v << 1, l, m);
        update(val, max(a, m + 1), b, v << 1 | 1, m + 1, r);
        counter[v] = counter[v << 1] + counter[v << 1 | 1];
    }
    
    void update(char val, int b)
    {
        update(val, 0, b, 1, 0, n - 1);
    }
    
    void res(int v, int l, int r, string &s)
    {
        if (l == r)
        {
            if (counter[v] == 1) s += 'a';
            else s += 'b';
            return;
        }
        int m = (l + r) >> 1;
        push(v, l, r);
        res(v << 1, l, m, s);
        res(v << 1 | 1, m + 1, r, s);
    }
    
    string res()
    {
        string ans = "";
        res(1, 0, n - 1, ans);
        return ans;
    }
    
};

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    string s;
    cin >> n >> m >> s;
    segtree st(s);
    while (m--)
    {
        int x;
        char a, b;
        cin >> x >> a >> b;
        st.update(b, st.get(a, x));
    }
    cout << st.res();
    return 0;
}
